<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif: xslShowHelp" />
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:variable name="numberAlign" select="count(//HorizontalAlignment)"/>
    <!-- Horizontal Alignment Curve Set Element Review Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis prvků směrového motivu oblouku</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis prvků směrového motivu oblouku</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/>
                                    <br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní grid:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <table class="margin" width="90%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:choose>
                                        <xsl:when test="$numberAlign &gt; 1">
                                            <tr>
                                                <th colspan="5" lang="en" style="color:red">
                                                    Tento výpis není vhodný pro více tras najednou.				  
                                                </th>
                                            </tr>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:for-each select="HorizontalAlignment[HorizontalCurveSets]">
                                                <tbody>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Název trasy:&#xa0;</th>
                                                        <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                                    </tr>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Popis trasy:&#xa0;</th>
                                                        <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                                    </tr>
                                                    <tr>
                                                        <th align="right" colspan="2" lang="en">Styl trasy:&#xa0;</th>
                                                        <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                                    </tr>
                                                    <xsl:apply-templates/>
                                                    <tr><td colspan="5">&#xa0;</td></tr>
                                                </tbody>
                                            </xsl:for-each>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Curveset Point Data -->
    <xsl:template match="CurvesetPoint[@pointType != 'POB' and @pointType != 'POE' and @pointType != 'PI']">
        <tr>
            <td align="left" lang="en" valign="top"><br/>Motiv - skladba:</td>
            <td align="left" colspan="4" valign="top"><br/><xsl:value-of select="@pointType"/></td>
        </tr>
        <tr>
            <th/>
            <th/>
            <th align="right" class="underline" lang="en">Staničení</th>
            <th align="right" class="underline" lang="en">Y</th>
            <th align="right" class="underline" lang="en">X</th>
        </tr>
        <tr>
            <td align="right"><xsl:value-of select="GeometryPoint/@type"/></td>
            <td align="right"> ( <xsl:value-of select="GeometryPoint/@name"/> )</td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
            </td>
        </tr>
        <tr><td colspan="5">&#xa0;</td></tr>
        <tr>
            <td align="right" colspan="2" lang="en">Celkový středový úhel:</td>
            <td align="right">
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>
            </td>
            <td align="left" lang="en">
                <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection='cw'">Vpravo</xsl:if>
                <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection = 'ccw'">Vlevo</xsl:if>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Délka první tečny:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@tangentLengthStart))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">Délka druhé tečny:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@tangentLengthEnd))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2" lang="en">zo:</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@external))"/>
            </td>
        </tr>
        <tr><td colspan="5">&#xa0;</td></tr>
        <xsl:call-template name="ElementData">
            <xsl:with-param name="startEle" select="@curveSetStartElement"/>
            <xsl:with-param name="stopEle" select="@curveSetStopElement"/>
        </xsl:call-template>
        <tr><td colspan="5"><hr size="1"/></td></tr>
    </xsl:template>
    <!-- Specify Element Data to Include by Start and End Elements of Curveset -->
    <xsl:template name="ElementData">
        <xsl:param name="startEle"/>
        <xsl:param name="stopEle"/>
        <xsl:variable name="nxtEle" select="$startEle + 1"/>
        <xsl:for-each select="//HorizontalElements">
            <xsl:apply-templates mode="Curveset">
                <xsl:with-param name="eleNum" select="$startEle"/>
            </xsl:apply-templates>
        </xsl:for-each>
        <xsl:if test="$nxtEle &lt;= $stopEle">
            <xsl:call-template name="ElementData">
                <xsl:with-param name="startEle" select="$nxtEle"/>
                <xsl:with-param name="stopEle" select="$stopEle"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <!-- Horizontal Circular Data -->
    <xsl:template match="HorizontalCircle" mode="Curveset">
        <xsl:param name="eleNum"/>
        <xsl:if test="@elementNumber = $eleNum">
            <tr>
                <td align="left" colspan="5" lang="en"><br/>Prvek: Oblouk</td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="Start/@type"/></td>
                <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
                </td>
            </tr>
            <xsl:if test="PI">
                <tr>
                    <td align="right"><xsl:value-of select="PI/@type"/></td>
                    <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="Center/@type"/></td>
                <td align="right">( <xsl:value-of select="Center/@name"/> )</td>
                <td />
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Center/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Center/@easting))"/>
                </td>
            </tr>
            <xsl:if test="StationEquation">
                <xsl:for-each select="StationEquation">
                    <tr>
                        <td align="right" colspan="2" lang="en">RovVst</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" colspan="2" lang="en">RovVyst</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="End/@type"/></td>
                <td align="right">( <xsl:value-of select="End/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Poloměr:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Středový úhel:</td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                </td>
                <td align="left" lang="en">
                    <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
                    <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">
                    <xsl:if test="../../@curvatureDefinition = 'arc'">
                         Stupeň křivosti (Oblouk):
                    </xsl:if>
                    <xsl:if test="../../@curvatureDefinition = 'chord'">
                        Stupeň křivosti (Tětiva):
                    </xsl:if>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Délka:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Tečna:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Tětiva:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">zo:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <!-- Horizontal Spiral Data -->
    <xsl:template match="HorizontalSpiral" mode="Curveset">
        <xsl:param name="eleNum"/>
        <xsl:if test="@elementNumber = $eleNum">
            <tr>
                <td align="left" colspan="5" lang="en"><br/>Prvek: 
                    <xsl:choose>
                        <xsl:when test="@compound = 'false'">
                            <xsl:value-of select="@type"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text> Složená </xsl:text>
                            <xsl:value-of select="@type"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="Start/@type"/></td>
                <td align="right">( <xsl:value-of select="Start/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right"><xsl:value-of select="PI/@type"/></td>
                <td align="right">( <xsl:value-of select="PI/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat( number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
                </td>
            </tr>
            <xsl:if test="StationEquation">
                <xsl:for-each select="StationEquation">
                    <tr>
                        <td align="right" colspan="2" lang="en">RovVst</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" colspan="2" lang="en">RovVyst</td>
                        <td align="right">
                            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                        </td>
                        <td align="right">
                            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
            <tr>
                <td align="right"><xsl:value-of select="End/@type"/></td>
                <td align="right">( <xsl:value-of select="End/@name"/> )</td>
                <td align="right">
                    <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Vstupní poloměr:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Výstupní poloměr:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Délka:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Úhel:</td>
                <td align="right">
                    <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
                </td>
                <td lang="en">
                    <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
                    <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Parametr:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@aConstant))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">X:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Y:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">dR:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@p))"/>
                </td>
            </tr>
            <tr>
                <td align="right" colspan="2" lang="en">Xs:</td>
                <td align="right">
                    <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat v příkazu <em>Nástroje &gt; XML výpisy &gt; Geometrie</em> nejméně jednu směrovou trasu s nejméně jedním obloukem v poli<em> Vybráno</em>.&#xa0; Tento výpis není vhodný pro více tras najednou.
            </p>
            <p class="normal1" lang="en">
                Tento výpis vypisuje seznam všech prvků samostatně pro každý motiv oblouku.&#xa0; 
            </p>
            <p class="normal1" lang="en">
                Tento výpis nepodporuje XML data vytvořená ve verzích před V8.8.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2010 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
